// quickSort1.java
// Program demonstruje prost wersj algorytmu quicksort
// Aby uruchomi ten program: C>java QuickSort1App
////////////////////////////////////////////////////////////////
class ArrayIns
   {
   private long[] theArray;          // odwoanie do tablicy theArray
   private int nElems;               // ilo elementw w tablicy
//--------------------------------------------------------------
   public ArrayIns(int max)          // konstruktor
      {
      theArray = new long[max];      // tworzymy tablic
      nElems = 0;                    // pocztkowo pust
      }
//--------------------------------------------------------------
   public void insert(long value)    // zapis elementu w tablicy
      {
      theArray[nElems] = value;      // wstawiamy element
      nElems++;                      // inkrementujemy ilo elementw
      }
//--------------------------------------------------------------
   public void display()             // wywietlenie zawartoci tablicy
      {
      System.out.print("A=");
      for(int j=0; j<nElems; j++)    // dla kadego elementu,
         System.out.print(theArray[j] + " ");  // wywietlamy go
      System.out.println("");
      }
//--------------------------------------------------------------
   public void quickSort()
      {
      recQuickSort(0, nElems-1);
      }
//--------------------------------------------------------------
   public void recQuickSort(int left, int right)
      {
      if(right-left <= 0)              // jeli rozmiar <= 1,
          return;                      //    ju posortowane
      else                             // rozmiar wynosi 2 lub wicej
         {
         long pivot = theArray[right];      // wybieramy skrajny prawy element
                                            // dzielimy zakres
         int partition = partitionIt(left, right, pivot);
         recQuickSort(left, partition-1);   // sortujemy lew stron
         recQuickSort(partition+1, right);  // sortujemy praw stron
         }
      }  // koniec metody recQuickSort()
//--------------------------------------------------------------
    public int partitionIt(int left, int right, long pivot)
       {
       int leftPtr = left-1;           // left    (po ++)
       int rightPtr = right;           // right-1 (po --)
       while(true)
          {                            // znajdujemy wikszy element
          while( theArray[++leftPtr] < pivot )
             ;  // (nic nie robimy)
                                       // znajdujemy mniejszy element
          while(rightPtr > 0 && theArray[--rightPtr] > pivot)
             ;  // (nic nie robimy)

          if(leftPtr >= rightPtr)      // jeli kolejno wskanikw si zmieni,
             break;                    //    dzielimy dane
          else                         // kolejo nie ulega zmianie, a zatem
             swap(leftPtr, rightPtr);  //    zamieniamy elementy
          }  // koniec ptli while(true)
       swap(leftPtr, right);           // przenosimy element stanowicy o podziau
       return leftPtr;                 // zwracamy pooenie podziau
       }  // konic metody partitionIt()
//--------------------------------------------------------------
   public void swap(int dex1, int dex2)  // zamiana pooenia dwch elementw
      {
      long temp = theArray[dex1];        // zapisujemy A w temp
      theArray[dex1] = theArray[dex2];   // zapisujemy B w A
      theArray[dex2] = temp;             // zapisujemy temp w B
      }  // koniec metody swap(
//--------------------------------------------------------------
   }  // koniec klasy ArrayIns
////////////////////////////////////////////////////////////////
class QuickSort1App
   {
   public static void main(String[] args)
      {
      int maxSize = 16;             // wielko tablicy
      ArrayIns arr;
      arr = new ArrayIns(maxSize);  // tworzymy tablic

      for(int j=0; j<maxSize; j++)  // zapisujemy w tablicy 
         {                          // losowe elementy
         long n = (int)(java.lang.Math.random()*99);
         arr.insert(n);
         }
      arr.display();                // wywietlamy elementy
      arr.quickSort();              // sortujemy metod quicksort 
      arr.display();                // ponownie wywietlamy elementy
      }  // koniec metody main()
   }  // koniec klasy QuickSort1App
////////////////////////////////////////////////////////////////
